/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1823;
import net.minecraft.class_1826;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_727;
import net.minecraft.class_746;
import net.minecraft.class_9239;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.api_impl.VRClientAPIImpl;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.VehicleTracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class VRPlayer {
    private final class_310 mc = class_310.method_1551();
    private final ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    public VRData vrdata_room_pre;
    public VRData vrdata_world_pre;
    public VRData vrdata_room_post;
    public VRData vrdata_world_post;
    public VRData vrdata_world_render;
    public float worldScale;
    private float rawWorldScale;
    private boolean teleportOverride;
    public class_243 roomOrigin;
    private boolean isFreeMoveCurrent;
    public double wfMode;
    public int wfCount;
    public int roomScaleMovementDelay;
    private boolean initDone;
    public boolean onTick;

    public VRPlayer() {
        this.worldScale = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.rawWorldScale = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.teleportOverride = false;
        this.roomOrigin = class_243.field_1353;
        this.isFreeMoveCurrent = true;
        this.wfMode = 0.0;
        this.wfCount = 0;
        this.roomScaleMovementDelay = 0;
        this.initDone = false;
        this.vrdata_room_pre = new VRData(class_243.field_1353, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_room_post = new VRData(class_243.field_1353, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(class_243.field_1353, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_pre = new VRData(class_243.field_1353, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
    }

    public VRData getVRDataWorld() {
        return this.vrdata_world_render != null ? this.vrdata_world_render : this.vrdata_world_pre;
    }

    public static VRPlayer get() {
        return ClientDataHolderVR.getInstance().vrPlayer;
    }

    public static class_243 roomToWorldPos(Vector3fc pos, VRData data) {
        Vector3f out = pos.mul(data.worldScale, new Vector3f());
        out = out.rotateY(data.rotation_radians);
        return data.origin.method_1031((double)out.x, (double)out.y, (double)out.z);
    }

    public static Vector3f worldToRoomPos(class_243 pos, VRData data) {
        Vector3f out = MathUtils.subtractToVector3f(pos, data.origin);
        out = out.div(data.worldScale);
        return out.rotateY(-data.rotation_radians);
    }

    public void postPoll() {
        this.vrdata_room_pre = new VRData(class_243.field_1353, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        GuiHandler.processGui();
        KeyboardHandler.processGui();
        RadialHandler.processGui();
    }

    public void preTick() {
        this.onTick = true;
        this.vrdata_world_pre = new VRData(this.roomOrigin, this.dh.vrSettings.walkMultiplier, this.worldScale, (float)Math.PI / 180 * this.dh.vrSettings.worldRotation);
        VRSettings.ServerOverrides.Setting worldScaleOverride = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE);
        float scaleSetting = worldScaleOverride.getFloat();
        if (MethodHolder.isInMenuRoom()) {
            this.worldScale = 1.0f;
        } else {
            if (this.wfCount > 0 && !this.mc.method_1493()) {
                if (this.wfCount < 40) {
                    this.rawWorldScale = (float)((double)this.rawWorldScale - this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale < scaleSetting) {
                            this.rawWorldScale = scaleSetting;
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale > scaleSetting) {
                        this.rawWorldScale = scaleSetting;
                    }
                } else {
                    this.rawWorldScale = (float)((double)this.rawWorldScale + this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale > class_3532.method_15363((float)20.0f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax())) {
                            this.rawWorldScale = class_3532.method_15363((float)20.0f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax());
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale < class_3532.method_15363((float)0.1f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax())) {
                        this.rawWorldScale = class_3532.method_15363((float)0.1f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax());
                    }
                }
                --this.wfCount;
            } else {
                this.rawWorldScale = scaleSetting;
            }
            this.worldScale = this.rawWorldScale;
            this.worldScale *= ScaleHelper.getEntityEyeHeightScale((class_1309)this.mc.field_1724, ClientUtils.getCurrentPartialTick());
            this.worldScale = class_3532.method_15363((float)this.worldScale, (float)0.025f, (float)100.0f);
            if (this.mc.field_1687 != null && this.mc.method_1542() && (worldScaleOverride.isValueMinOverridden() || worldScaleOverride.isValueMaxOverridden())) {
                float measuredIPD = this.dh.vr.getEyePosition(RenderPass.LEFT).sub((Vector3fc)this.dh.vr.getEyePosition(RenderPass.RIGHT)).length();
                float queriedIPD = this.dh.vr.getIPD();
                float runtimeWorldScale = queriedIPD / measuredIPD;
                float actualWorldScale = this.rawWorldScale * runtimeWorldScale;
                if (actualWorldScale < worldScaleOverride.getValueMin() * 0.99f || actualWorldScale > worldScaleOverride.getValueMax() * 1.01f) {
                    VRSettings.LOGGER.info("Vivecraft: disconnected user from server. runtime IPD: {}, measured IPD: {}, runtime worldscale: {}", new Object[]{Float.valueOf(queriedIPD), Float.valueOf(measuredIPD), Float.valueOf(runtimeWorldScale)});
                    this.mc.field_1687.method_8525();
                    this.mc.method_56134((class_437)new class_419((class_437)new class_500((class_437)new class_442()), (class_2561)class_2561.method_43471((String)"vivecraft.message.worldscaleOutOfRange.title"), (class_2561)class_2561.method_43469((String)"vivecraft.message.worldscaleOutOfRange", (Object[])new Object[]{class_2561.method_43470((String)"%.2fx".formatted(Float.valueOf(worldScaleOverride.getValueMin()))).method_27694(style -> style.method_10977(class_124.field_1060)), class_2561.method_43470((String)"%.2fx".formatted(Float.valueOf(worldScaleOverride.getValueMax()))).method_27694(style -> style.method_10977(class_124.field_1060)), class_2561.method_43470((String)this.dh.vr.getRuntimeName()).method_27694(style -> style.method_10977(class_124.field_1065))})));
                }
            }
        }
        if (this.dh.vrSettings.seated && !MethodHolder.isInMenuRoom()) {
            this.dh.vrSettings.worldRotation = this.dh.vr.seatedRot;
        }
        if (!(this.mc.field_1687 == null || this.mc.method_1576() != null && this.mc.method_1576().method_54809())) {
            VRClientAPIImpl.INSTANCE.addPoseToHistory(this.vrdata_world_pre.asVRPose(), this.mc.field_1724.method_19538());
        }
    }

    public void postTick() {
        Vector3f scaleOffset = this.vrdata_world_pre.hmd.getScalePositionOffset(this.worldScale);
        this.roomOrigin = this.roomOrigin.method_1023((double)scaleOffset.x, (double)scaleOffset.y, (double)scaleOffset.z);
        float end = this.dh.vrSettings.worldRotation;
        float start = 57.295776f * this.vrdata_world_pre.rotation_radians;
        this.rotateOriginAround(-end + start, this.vrdata_world_pre.getNewHeadPivot(this.roomOrigin, this.worldScale));
        this.vrdata_room_post = new VRData(class_243.field_1353, this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(this.roomOrigin, this.dh.vrSettings.walkMultiplier, this.worldScale, (float)Math.PI / 180 * this.dh.vrSettings.worldRotation);
        this.doPermanentLookOverride(this.mc.field_1724, this.vrdata_world_post);
        ClientNetworking.sendVRPlayerPositions(this);
        this.onTick = false;
    }

    public void preRender(float partialTick) {
        float interpolatedWorldScale = class_3532.method_16439((float)partialTick, (float)this.vrdata_world_pre.worldScale, (float)this.vrdata_world_post.worldScale);
        float end = this.vrdata_world_post.rotation_radians;
        float start = this.vrdata_world_pre.rotation_radians;
        float difference = Math.abs(end - start);
        if (difference > (float)Math.PI) {
            if (end > start) {
                start += (float)Math.PI * 2;
            } else {
                end += (float)Math.PI * 2;
            }
        }
        float interpolatedWorldRotation_Radians = class_3532.method_16439((float)partialTick, (float)start, (float)end);
        class_243 interpolatedRoomOrigin = MathUtils.vecDLerp(this.vrdata_world_pre.origin, this.vrdata_world_post.origin, partialTick);
        this.vrdata_world_render = new VRData(interpolatedRoomOrigin, this.dh.vrSettings.walkMultiplier, interpolatedWorldScale, interpolatedWorldRotation_Radians);
        for (Tracker tracker : ClientDataHolderVR.getInstance().getTrackers()) {
            if (tracker.processType() != Tracker.ProcessType.PER_FRAME) continue;
            tracker.idleProcess(this.mc.field_1724);
            if (tracker.isActive(this.mc.field_1724)) {
                tracker.activeProcess(this.mc.field_1724);
                continue;
            }
            tracker.inactiveProcess(this.mc.field_1724);
        }
        this.dh.menuHandOff = MethodHolder.isInMenuRoom() || this.mc.field_1755 != null || KeyboardHandler.SHOWING;
        this.dh.menuHandMain = this.dh.menuHandOff || this.dh.hotbarModule.hotbar >= 0 && this.dh.vrSettings.vrTouchHotbar;
    }

    public void postRender(float partialTick) {
    }

    public void setRoomOrigin(double x, double y, double z, boolean reset) {
        if (reset && this.vrdata_world_pre != null) {
            this.vrdata_world_pre.origin = new class_243(x, y, z);
        }
        this.roomOrigin = new class_243(x, y, z);
    }

    public void snapRoomOriginToPlayerEntity(class_1297 entity, boolean reset, boolean instant) {
        if (Thread.currentThread().getName().equals("Server thread") || entity == null || entity.method_19538() == class_243.field_1353 || this.dh.sneakTracker.sneakCounter > 0) {
            return;
        }
        class_243 camPos = instant ? this.vrdata_world_pre.getNewHeadPivot(this.roomOrigin, this.worldScale).method_1020(this.roomOrigin) : this.vrdata_world_pre.getHeadPivot().method_1020(this.vrdata_world_pre.origin);
        double x = entity.method_23317() - camPos.field_1352;
        double y = entity.method_23318();
        double z = entity.method_23321() - camPos.field_1350;
        if (entity instanceof PlayerExtension) {
            PlayerExtension extension = (PlayerExtension)entity;
            y += extension.vivecraft$getRoomYOffsetFromPose();
        }
        this.setRoomOrigin(x, y, z, reset);
    }

    public float rotDiff_Degrees(float start, float end) {
        double x = Math.toRadians(end);
        double y = Math.toRadians(start);
        return (float)Math.toDegrees(Math.atan2(Math.sin(x - y), Math.cos(x - y)));
    }

    public void rotateOriginAround(float degrees, class_243 origin) {
        class_243 point = this.roomOrigin;
        float rads = (float)Math.PI / 180 * degrees;
        if (rads != 0.0f) {
            this.setRoomOrigin((double)class_3532.method_15362((float)rads) * (point.field_1352 - origin.field_1352) - (double)class_3532.method_15374((float)rads) * (point.field_1350 - origin.field_1350) + origin.field_1352, point.field_1351, (double)class_3532.method_15374((float)rads) * (point.field_1352 - origin.field_1352) + (double)class_3532.method_15362((float)rads) * (point.field_1350 - origin.field_1350) + origin.field_1350, false);
        }
    }

    public void tick(class_746 player) {
        if (!((PlayerExtension)player).vivecraft$getInitFromServer()) {
            return;
        }
        if (!this.initDone) {
            VRSettings.LOGGER.info("Vivecraft: <Debug info start>\nRoom object: {}\nRoom origin: {}\nHmd position room: {}\nHmd position world: {}\nHmd Projection Left: {}\nHmd Projection Right: {}\n<Debug info end>\n", new Object[]{this, this.vrdata_world_pre.origin, this.vrdata_room_pre.hmd.getPosition(), this.vrdata_world_pre.hmd.getPosition(), this.dh.vrRenderer.eyeProj[0], this.dh.vrRenderer.eyeProj[1]});
            this.initDone = true;
        }
        this.doPlayerMoveInRoom(player);
        for (Tracker tracker : this.dh.getTrackers()) {
            if (tracker.processType() != Tracker.ProcessType.PER_TICK) continue;
            tracker.idleProcess(player);
            if (tracker.isActive(player)) {
                tracker.activeProcess(player);
                continue;
            }
            tracker.inactiveProcess(player);
        }
        if (player.method_5765()) {
            class_1308 mob;
            class_1297 entity = player.method_5854();
            if (entity instanceof class_1496) {
                class_1496 abstracthorse = (class_1496)entity;
                if (abstracthorse.method_66247() && abstracthorse.method_66672() && !this.dh.horseTracker.isActive(player)) {
                    abstracthorse.field_6283 = this.vrdata_world_pre.getBodyYaw();
                    this.dh.vehicleTracker.rotationCooldown = 10;
                }
            } else if (entity instanceof class_1308 && (mob = (class_1308)entity).method_66247()) {
                mob.field_6283 = this.vrdata_world_pre.getBodyYaw();
                this.dh.vehicleTracker.rotationCooldown = 10;
            }
        }
    }

    public void doPlayerMoveInRoom(class_746 player) {
        float climbShrink;
        double shrunkClimbHalfWidth;
        class_238 bbClimb;
        if (this.roomScaleMovementDelay > 0) {
            --this.roomScaleMovementDelay;
            return;
        }
        if (player == null || player.method_5715() || player.method_6113() || this.dh.jumpTracker.isjumping() || this.dh.climbTracker.isGrabbingLadder() || !player.method_5805() || this.dh.vehicleTracker.isRiding()) {
            return;
        }
        class_243 newHeadPivot = this.vrdata_world_pre.getNewHeadPivot(this.roomOrigin, this.worldScale);
        if (this.dh.vrSettings.realisticDismountEnabled && this.dh.vehicleTracker.canRoomscaleDismount(player)) {
            class_243 mountPos = player.method_5854().method_19538();
            double distance = Math.sqrt((newHeadPivot.field_1352 - mountPos.field_1352) * (newHeadPivot.field_1352 - mountPos.field_1352) + (newHeadPivot.field_1350 - mountPos.field_1350) * (newHeadPivot.field_1350 - mountPos.field_1350));
            if (distance > 1.0) {
                this.dh.sneakTracker.sneakCounter = 5;
            }
            return;
        }
        float playerHalfWidth = player.method_17681() / 2.0f;
        float playerHeight = player.method_17682();
        double x = newHeadPivot.field_1352;
        double y = player.method_23318();
        double z = newHeadPivot.field_1350;
        class_238 bb = new class_238(x - (double)playerHalfWidth, y, z - (double)playerHalfWidth, x + (double)playerHalfWidth, y + (double)playerHeight, z + (double)playerHalfWidth);
        class_243 torso = new class_243(x, y, z);
        if (this.mc.field_1687.method_8587((class_1297)player, bb)) {
            player.method_23327(x, !this.dh.vrSettings.simulateFalling ? y : player.method_23318(), z);
            player.method_5857(bb);
            player.field_6017 = 0.0;
        } else if ((this.dh.vrSettings.walkUpBlocks && ((PlayerExtension)player).vivecraft$getMuhJumpFactor() == 1.0f || this.dh.climbTracker.isGrabbingLadder() && this.dh.vrSettings.realisticClimbEnabled) && player.field_6017 == 0.0 && !this.mc.field_1687.method_8587((class_1297)player, bbClimb = new class_238(torso.field_1352 - (shrunkClimbHalfWidth = (double)(playerHalfWidth - (climbShrink = player.method_18377(player.method_18376()).comp_2185() * 0.45f))), bb.field_1322, torso.field_1350 - shrunkClimbHalfWidth, torso.field_1352 + shrunkClimbHalfWidth, bb.field_1325, torso.field_1350 + shrunkClimbHalfWidth))) {
            int extra = 0;
            if (player.method_6101() && this.dh.vrSettings.realisticClimbEnabled) {
                extra = 6;
            }
            for (int i = 0; i <= 10 + extra; ++i) {
                if (!this.mc.field_1687.method_8587((class_1297)player, bb = bb.method_989(0.0, 0.1, 0.0))) continue;
                player.method_23327(x, bb.field_1322, z);
                player.method_5857(bb);
                class_243 dest = this.roomOrigin.method_1031(0.0, (double)(0.1f * (float)(i + 1)), 0.0);
                this.setRoomOrigin(dest.field_1352, dest.field_1351, dest.field_1350, false);
                player.field_6017 = 0.0;
                ((PlayerExtension)player).vivecraft$stepSound(class_2338.method_49638((class_2374)player.method_19538()), player.method_19538());
                break;
            }
        }
    }

    public class_243 getEstimatedTorsoPosition(double x, double y, double z) {
        class_746 player = this.mc.field_1724;
        class_243 look = player.method_5720();
        class_243 forward = new class_243(look.field_1352, 0.0, look.field_1350).method_1029();
        float factor = (float)look.field_1351 * 0.25f;
        return new class_243(x + forward.field_1352 * (double)factor, y + forward.field_1351 * (double)factor, z + forward.field_1350 * (double)factor);
    }

    public void blockDust(double x, double y, double z, int count, class_2338 bp, class_2680 bs, float scale, float velScale) {
        for (int i = 0; i < count; ++i) {
            class_727 terrainparticle = new class_727(this.mc.field_1687, x, y, z, 0.0, 0.0, 0.0, bs);
            terrainparticle.method_3075(velScale);
            this.mc.field_1713.method_3058(terrainparticle.method_3087(scale));
        }
    }

    public void updateFreeMove() {
        if (this.dh.teleportTracker.isAiming()) {
            this.isFreeMoveCurrent = false;
        }
        if (this.mc.field_1724.field_3913 != null && (this.mc.field_1724.field_3913.method_3128().field_1342 != 0.0f || this.mc.field_1724.field_3913.method_3128().field_1343 != 0.0f)) {
            this.isFreeMoveCurrent = true;
        }
        this.updateTeleportKeys();
    }

    public boolean getFreeMove() {
        if (this.dh.vrSettings.seated) {
            return this.dh.vrSettings.seatedFreeMove || !this.isTeleportEnabled();
        }
        return this.isFreeMoveCurrent || this.dh.vrSettings.forceStandingFreeMove;
    }

    public String toString() {
        return "VRPlayer:\n    origin: %s\n    rotation: %.3f\n    scale: %.3f\n    room_pre: %s\n    world_pre: %s\n    world_post: %s\n    world_render: %s".formatted(this.roomOrigin, Float.valueOf(this.dh.vrSettings.worldRotation), Float.valueOf(this.worldScale), this.vrdata_room_pre, this.vrdata_world_pre, this.vrdata_world_post, this.vrdata_world_render);
    }

    public class_243 getRightClickLookOverride(class_1657 entity, int c) {
        class_1799 itemStack;
        class_243 out = entity.method_5720();
        if (((GameRendererExtension)this.mc.field_1773).vivecraft$getCrossVec() != null) {
            out = entity.method_5836(1.0f).method_1020(((GameRendererExtension)this.mc.field_1773).vivecraft$getCrossVec()).method_1029().method_22882();
        }
        class_1799 class_17992 = itemStack = c == 0 ? entity.method_6047() : entity.method_6079();
        if (itemStack.method_7909() instanceof class_1823 || itemStack.method_7909() instanceof class_1771 || itemStack.method_7909() instanceof class_1826 || itemStack.method_7909() instanceof class_1812 || itemStack.method_7909() instanceof class_1753 || itemStack.method_7909() instanceof class_1787 || itemStack.method_7909() instanceof class_9239 || itemStack.method_7909() instanceof class_1764 && class_1764.method_7781((class_1799)itemStack) || itemStack.method_31573(ViveItemTags.VIVECRAFT_THROW_ITEMS)) {
            VRData data = this.dh.vrPlayer.vrdata_world_pre;
            Vector3fc aim = this.dh.bowTracker.getAimVector();
            if (this.dh.bowTracker.isNotched() && aim != null && aim.lengthSquared() > 0.0f) {
                out = new class_243((double)aim.x(), (double)aim.y(), (double)aim.z());
            } else if (this.dh.vrSettings.aimDevice != VRSettings.AimDevice.HMD) {
                out = new class_243(data.getController(c).getDirection());
            }
        } else if (itemStack.method_7909() == class_1802.field_8550 && this.dh.blockModule.bukkit[c] && ClientNetworking.getActiveBodyPart().ordinal() == c && ClientNetworking.IS_LAST_BODY_PART_AIM) {
            out = entity.method_5836(1.0f).method_1020(this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition()).method_1029().method_22882();
        }
        return out;
    }

    public void doPermanentLookOverride(class_746 player, VRData data) {
        if (player == null) {
            return;
        }
        if (player.method_5765()) {
            Vector3f dir = VehicleTracker.getSteeringDirection(player);
            if (dir != null) {
                player.method_36457((float)Math.toDegrees(Math.asin(-dir.y / dir.length())));
                player.method_36456((float)Math.toDegrees(Math.atan2(-dir.x, dir.z)));
                player.method_5847(player.method_36454());
            }
        } else if (player.method_6039()) {
            if (player.method_6058() == class_1268.field_5808) {
                player.method_36456(data.getController(0).getYaw());
                player.method_5847(player.method_36454());
                player.method_36457(-data.getController(0).getPitch());
            } else {
                player.method_36456(data.getController(1).getYaw());
                player.method_5847(player.method_36454());
                player.method_36457(-data.getController(1).getPitch());
            }
        } else if (player.method_5624() && (player.field_3913.field_54155.comp_3163() || this.mc.field_1690.field_1903.method_1434()) || player.method_6128() || player.method_5681() && player.field_6250 > 0.0f) {
            switch (this.dh.vrSettings.getVrFreeMoveMode(player.method_6128(), data.fbtMode)) {
                case CONTROLLER: {
                    player.method_36456(data.getController(1).getYaw());
                    player.method_36457(-data.getController(1).getPitch());
                    break;
                }
                case WAIST: {
                    player.method_36456(data.waist.getYaw());
                    player.method_36457(-data.hmd.getPitch());
                    break;
                }
                default: {
                    player.method_36456(data.hmd.getYaw());
                    player.method_36457(-data.hmd.getPitch());
                }
            }
            player.method_5847(player.method_36454());
        } else if (((GameRendererExtension)this.mc.field_1773).vivecraft$getCrossVec() != null) {
            class_243 playerToCrosshair = player.method_5836(1.0f).method_1020(((GameRendererExtension)this.mc.field_1773).vivecraft$getCrossVec());
            double what = playerToCrosshair.field_1351 / playerToCrosshair.method_1033();
            if (what > 1.0) {
                what = 1.0;
            }
            if (what < -1.0) {
                what = -1.0;
            }
            float pitch = (float)Math.toDegrees(Math.asin(what));
            float yaw = (float)Math.toDegrees(Math.atan2(playerToCrosshair.field_1352, -playerToCrosshair.field_1350));
            player.method_36457(pitch);
            player.method_36456(yaw);
            player.method_5847(yaw);
        } else {
            player.method_36456(data.hmd.getYaw());
            player.method_5847(player.method_36454());
            player.method_36457(-data.hmd.getPitch());
        }
    }

    public class_243 AimedPointAtDistance(VRData.VRDevicePose source, double distance) {
        class_243 controllerPos = source.getPosition();
        Vector3f controllerDir = source.getDirection();
        return controllerPos.method_1031((double)controllerDir.x * distance, (double)controllerDir.y * distance, (double)controllerDir.z * distance);
    }

    public class_239 rayTraceBlocksVR(VRData source, int controller, double hitDistance, boolean hitFluids) {
        class_243 start = source.getController(controller).getPosition();
        class_243 end = this.AimedPointAtDistance(source.getController(controller), hitDistance);
        return this.mc.field_1687.method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, hitFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)this.mc.field_1724));
    }

    public boolean isTeleportSupported() {
        return !VRServerPerms.INSTANCE.noTeleportClient;
    }

    public boolean isTeleportOverridden() {
        return this.teleportOverride;
    }

    public boolean isTeleportEnabled() {
        boolean enabled;
        boolean bl = enabled = (!VRServerPerms.INSTANCE.noTeleportClient || this.teleportOverride) && ClientNetworking.SERVER_ALLOWS_DIRECT_TELEPORT;
        if (this.dh.vrSettings.seated) {
            return enabled;
        }
        return enabled && !this.dh.vrSettings.forceStandingFreeMove;
    }

    public void setTeleportOverride(boolean override) {
        this.teleportOverride = override;
        this.updateTeleportKeys();
    }

    public void updateTeleportKeys() {
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyTeleport).setEnabled(this.isTeleportEnabled());
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyTeleportFallback).setEnabled(!this.isTeleportEnabled());
    }
}

